#ifndef ClientThread_Cpp
#define ClientThread_Cpp
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HANDLE ghEvent_ClientThread = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::Start_ClientThread(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::Start_ClientThread.\n");
    #endif

	ghEvent_ClientThread = CreateEvent(NULL, TRUE, FALSE, "Client_Thread_Function");

	memset(&CTI, 0, sizeof(CTI));
    CTI.Client = iClient;

    if((hcClient_Thread_Handle[iClient] = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)Client_Thread_Function, (LPVOID) this, 0, (LPDWORD) &dwcClient_Thread_ID[iClient])) == NULL)
    {
        FatalError(__FILE__, __LINE__, "CreateThread failed.");
        CloseHandle(ghEvent_ClientThread);
        return false;
    }

    if(WaitForSingleObject(ghEvent_ClientThread, 5000) == WAIT_TIMEOUT)
    {
        CloseHandle(ghEvent_ClientThread);
        return false;
    }

	//The thread was started, trigger the event.
	Events.OnBeginClientThread(this, iClient);

	CloseHandle(ghEvent_ClientThread);
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::WaitOnClientThreadToExit(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::WaitOnClientThreadToExit.\n");
    #endif

    DWORD dwExitCode = 0;

    int iWaitCount = 0;

    while(GetExitCodeThread(hcClient_Thread_Handle[iClient], &dwExitCode))
    {
        if(dwExitCode != STILL_ACTIVE || iWaitCount == 500)
        {
            if(iWaitCount == 500)
            {
                printf("Possible thread dead-lock. Client[%d]'s thread will be terminated.\n", iClient);
                TerminateThread(hcClient_Thread_Handle[iClient], 1);
            }

            //The thread was stopped, trigger the event.
			Events.OnEndClientThread(this, iClient);

			CloseHandle(hcClient_Thread_Handle[iClient]);
            dwcClient_Thread_ID[iClient] = 0;
            return true;
        }

        iWaitCount++;
        Sleep(1);
    }

	//The thread was stopped, trigger the event.
	Events.OnEndClientThread(this, iClient);

    FatalError(__FILE__, __LINE__, "GetExitCodeThread failed.");
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Client_Thread_Function(LPVOID pvThread)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> Client_Thread_Function.\n");
    #endif

    //---------------------(Initialize Thread [Begin])----------
   	CSockSrvr *pSockSrvr = ((CSockSrvr *)pvThread);

	int iClient = ((CSockSrvr *)pvThread)->CTI.Client;

	SetEvent(ghEvent_ClientThread);
    //---------------------(Initialize Thread [END])----------

    char sRecvBuf[IDEAL_RECV_SIZE + 1];
    int iRecvBufSz = 0;

    while(pSockSrvr->bcConnected[iClient] && !pSockSrvr->bcDisconnect[iClient])
    {
        if(pSockSrvr->GetClientData(iClient, sRecvBuf, &iRecvBufSz))
        {
            //sRecvBuf[iRecvBufSz] = '\0';
			//printf("GotSize[%d] : %d\n", iClient, iRecvBufSz);
			//printf("GotData[%d]:%s\n", iClient, sRecvBuf);
			if(CCI.bIsAuthenticated == false)
			{
				int iAuthResult = PerformHandShake(pSockSrvr, iClient, sRecvBuf, iRecvBufSz);
				if(iAuthResult == AUTH_FAILED || iAuthResult == AUTH_ERROR)
				{
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iAuthResult == AUTH_SUCCESS){
					if(CCI.cCustSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
					{
						WriteLog(pSockSrvr->icClientID[iClient], "Successfully connected to the database.");
						CCI.bCustDBConnected = true;
						CCI.bIsAuthenticated = true;
						pSockSrvr->SetNextSendData(iClient, "::SendFirstSQL");
					}
					else{
						WriteLog(pSockSrvr->icClientID[iClient], "Failed to connect to the database.");
						pSockSrvr->bcDisconnect[iClient] = true;
						return 0;						
					}
				}
				else if(iAuthResult == AUTH_OK){
					//The authentication process is still in process, all is well.
				}
			}
			else{
				int iCmdResult = ProcessCommand(pSockSrvr, iClient, sRecvBuf, iRecvBufSz);
				if(iCmdResult == CMD_ERROR)
				{
					WriteLog(pSockSrvr->icClientID[iClient], "Process command returned with an error.");
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iCmdResult == CMD_DONE) {
					pSockSrvr->bcDisconnect[iClient] = true;
					return 0;
				}
				else if(iCmdResult == CMD_OK) {
					//All is well.
				}
			}
		}
        else Sleep(CLIENTTHREAD_MS_WAIT);
    }

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

